function [yhat,dydx,rlr,yinf] = smth(h,x,y,kern)
%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
% MATLAB code: Exercise 9.1
% File: smth.m
%
% Purpose: Kernel smoothing function. Applies LL regression to 
%          weighted data.
%
% INPUT:
% x = abscissa values
% y = ordinate values
% h = smoothing parameter
% kern = kernel smoother 
%        kern = 0, uses Gaussian kernel  
%        kern = 1, uses 1/(1+x^2) 
%        kern = 2, uses Epanechnikov kernel 0.75*(1-x^2) on [-1<x<1]
%
% OUTPUT:
% yhat = local linear smooth of data y, using abscissa x, bandwidth
%        h and kernel function kern
% dydx = local linear estimate of derivative of y
% rlry = -dydx/(yhat-yinf) where yinf is estimated roughly as that 
%        portion of yhat for which dydx is smallish
% yinf (see above)
%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
zerotol=1e-14;

difs = meshgrid(x,x);
difs = difs' - difs;
kernvals = g(difs/h,kern);
y    = meshgrid(y,y)';
s0   = sum(kernvals);
t0   = sum(kernvals.*y);
temp = difs.*kernvals;
s1   = sum(temp);
t1   = sum(temp.*y);
temp = difs.*temp;
s2   = sum(temp);

% Add zerotol to avoid divide by zero on flat series
yhat = (s2.*t0 - s1.*t1)./((s0.*s2 - s1.*s1)+zerotol);

if nargout>1  % Only compute slope if required
        dydx = (s0.*t1 - s1.*t0)./((s0.*s2 - s1.*s1)+zerotol);
end
if nargout>2 % Only compute RLR and estimate yinf if rlr required
   sizex = max(size(x));
   q1    = floor(sizex/5);
   yinf  = mean(yhat((4*q1):sizex));
   rlr   = -1*dydx./(yhat-yinf);
end

% Next, the subfunction required
% Create Kernel evaluating subfunction

   function gx = g(x,kern)
   if kern==0
         gx = exp(-((x.*x)/2)) ; % Use x.*x not x.^2 for speed
      elseif kern==1   
         gx = 1./(1+(x.*x));
      elseif kern==2
         gx = max(0.75*(1-x.*x),0);
   end
   
%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
%  MAIN: Exercise 9.1
%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
y = load('Yt-n500-sinus.dat');
x = linspace(-2,2,500);
h = 0.02;
for i=1:500   
    z(i) = sin(x(i));
end
% Local linear regression 
[yhat2,dydx,rlr,yinf] = smth(h,x,y,2);  % Epanechnikov kernel
[yhat0,dydx,rlr,yinf] = smth(h,x,y,0);  % Gauss kernel

plot(x,z);
hold on; 
scatter(x,y,'black');
hold on;
plot(x,yhat2,'magenta');
hold on;
plot(x,yhat0,'black')
title('(a) Kernel Smoothing Regression');
legend('true','data','NW local constant','Local linear','location','northwest');